package cx.threeg.dcms.ui;

import android.app.Activity;
import android.app.Fragment;
import android.app.FragmentTransaction;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;

import cx.threeg.dcms.R;

public class MainActivity extends Activity {

    private HomeFragment home;
    private SettingsFragment settings;
    private HelpFragment help;

    @Override protected void onCreate(Bundle savedInstanceState){
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        Button bHome=(Button)findViewById(R.id.nav_home);
        Button bHelp=(Button)findViewById(R.id.nav_help);
        Button bSettings=(Button)findViewById(R.id.nav_settings);
        View.OnClickListener nav=new View.OnClickListener(){
            @Override public void onClick(View v){
                int id=v.getId();
                if(id==R.id.nav_home) show(getHome());
                else if(id==R.id.nav_help) show(getHelp());
                else if(id==R.id.nav_settings) show(getSettings());
            }
        };
        bHome.setOnClickListener(nav); bHelp.setOnClickListener(nav); bSettings.setOnClickListener(nav);
        show(getHome());
    }
    private void show(Fragment f){ FragmentTransaction ft=getFragmentManager().beginTransaction(); ft.replace(R.id.container,f); ft.commit(); }
    private Fragment getHome(){ if(home==null) home=new HomeFragment(); return home; }
    private Fragment getHelp(){ if(help==null) help=new HelpFragment(); return help; }
    private Fragment getSettings(){ if(settings==null) settings=new SettingsFragment(); return settings; }
}
